/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Calendar;

public class BinnaryClock
extends Applet {
    Clock c;

    public void init() {
        this.c = Clock.getClock(this.getParameter("type"));
        this.add(this.c);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Ask.ask();
        } else {
            try {
                int i = 0;
                while (i < args.length) {
                    ClockFrame.raiseClockFrame(args[i]);
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }

    public void stop() {
        this.c.halt();
    }

    private static class Spacer
    extends Canvas {
        Dimension d;

        public Spacer(Dimension size) {
            this.d = size;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.d);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.d);
        }
    }

    public static class Clock
    extends Panel
    implements Runnable {
        static final Color on = new Color(50, 50, 255);
        static final Color bin_time = new Color(50, 50, 255);
        static final Color time = new Color(50, 255, 50);
        static final Color off = new Color(50, 50, 100);
        static final Color bg = new Color(0, 0, 0);
        Thread t;
        boolean real_binnary;
        Dot[] h = null;
        Dot[] min = null;
        Dot[] sec = null;
        TimeLabel hL;
        TimeLabel minL;
        TimeLabel secL;
        static final int PLAIN = 0;
        static final int GROUPED = 1;
        static final int PACKED_GROUPED = 2;
        static final int EASY_GROUPED = 3;
        public static int BIG = 0;
        public static int PACKED = 1;
        public static int EASY = 2;

        public static Clock getClock(String what) {
            if (what == null || what.equals("grouped")) {
                return Clock.getGroupedClock(BIG);
            }
            if (what.equals("packedGrouped")) {
                return Clock.getGroupedClock(PACKED);
            }
            if (what.equals("plain")) {
                return Clock.getClock();
            }
            if (what.equals("easyGrouped")) {
                return Clock.getGroupedClock(EASY);
            }
            throw new IllegalArgumentException(String.valueOf(what) + " kann nicht als Parameter interpretiert werden.\n" + "M\u00f6glich sind: plain, grouped, packedGrouped und easyGrouped");
        }

        public static Clock getClock(int what) {
            if (what == PACKED) {
                return Clock.getGroupedClock(BIG);
            }
            if (what == 2) {
                return Clock.getGroupedClock(PACKED);
            }
            if (what == 0) {
                return Clock.getClock();
            }
            if (what == 3) {
                return Clock.getGroupedClock(EASY);
            }
            throw new IllegalArgumentException(String.valueOf(what) + " kann nicht als Parameter interpretiert werden.");
        }

        private Clock() {
            this(true);
        }

        private Clock(boolean full_bin) {
            this.setBackground(bg);
            this.setForeground(on);
            this.real_binnary = full_bin;
            this.hL = new TimeLabel(!full_bin);
            this.minL = new TimeLabel(!full_bin);
            this.secL = new TimeLabel(!full_bin);
            this.t = new Thread(this);
        }

        public static Clock getGroupedClock() {
            return Clock.getGroupedClock(BIG);
        }

        public static Clock getGroupedClock(int mode) {
            Spacer space;
            Clock c = new Clock(mode != EASY);
            if (mode == PACKED) {
                c.h = new Dot[6];
                c.min = new Dot[6];
                c.sec = new Dot[6];
            } else {
                c.h = new Dot[8];
                c.min = new Dot[8];
                c.sec = new Dot[8];
            }
            GridBagLayout gl = new GridBagLayout();
            c.setLayout(gl);
            GridBagConstraints normal = new GridBagConstraints();
            normal.anchor = 10;
            normal.fill = 1;
            normal.weightx = 1.0;
            normal.weighty = 1.0;
            GridBagConstraints dNormal = new GridBagConstraints();
            dNormal.anchor = 10;
            dNormal.fill = 1;
            dNormal.gridwidth = 2;
            dNormal.weightx = 1.0;
            dNormal.weighty = 1.0;
            GridBagConstraints cSpace = new GridBagConstraints();
            cSpace.anchor = 10;
            cSpace.fill = 1;
            cSpace.weightx = 0.1;
            cSpace.weighty = 0.1;
            GridBagConstraints right = new GridBagConstraints();
            right.anchor = 10;
            right.fill = 1;
            right.weightx = 1.0;
            right.weighty = 1.0;
            right.gridwidth = 0;
            Dimension sSize = new Dimension(10, 1);
            int half = c.h.length / 2;
            int i = half - 1;
            while (i >= 0) {
                c.h[i + half] = new Dot(false);
                gl.setConstraints(c.h[i + half], normal);
                c.add(c.h[i + half]);
                c.h[i] = new Dot(false);
                gl.setConstraints(c.h[i], normal);
                c.add(c.h[i]);
                space = new Spacer(sSize);
                gl.setConstraints(space, cSpace);
                c.add(space);
                c.min[i + half] = new Dot(false);
                c.add(c.min[i + half]);
                gl.setConstraints(c.min[i + half], normal);
                c.min[i] = new Dot(false);
                gl.setConstraints(c.min[i], normal);
                c.add(c.min[i]);
                space = new Spacer(sSize);
                gl.setConstraints(space, cSpace);
                c.add(space);
                c.sec[i + half] = new Dot(false);
                c.add(c.sec[i + half]);
                gl.setConstraints(c.sec[i + half], normal);
                c.sec[i] = new Dot(false);
                gl.setConstraints(c.sec[i], right);
                c.add(c.sec[i]);
                --i;
            }
            gl.setConstraints(c.hL, dNormal);
            c.add(c.hL);
            space = new Spacer(sSize);
            gl.setConstraints(space, cSpace);
            c.add(space);
            gl.setConstraints(c.minL, dNormal);
            c.add(c.minL);
            space = new Spacer(sSize);
            gl.setConstraints(space, cSpace);
            c.add(space);
            gl.setConstraints(c.secL, right);
            c.add(c.secL);
            c.doLayout();
            c.drawTime();
            c.t.start();
            return c;
        }

        public static Clock getClock() {
            Clock c = new Clock(true);
            c.h = new Dot[6];
            c.min = new Dot[6];
            c.sec = new Dot[6];
            GridBagLayout gl = new GridBagLayout();
            c.setLayout(gl);
            GridBagConstraints normal = new GridBagConstraints();
            normal.anchor = 10;
            normal.fill = 1;
            normal.weightx = 1.0;
            normal.weighty = 1.0;
            GridBagConstraints cSpace = new GridBagConstraints();
            cSpace.anchor = 10;
            cSpace.fill = 1;
            cSpace.weightx = 0.1;
            cSpace.weighty = 0.1;
            GridBagConstraints right = new GridBagConstraints();
            right.anchor = 10;
            right.fill = 1;
            right.weightx = 1.0;
            right.weighty = 1.0;
            right.gridwidth = 0;
            Dimension sSize = new Dimension(10, 1);
            int i = c.h.length - 1;
            while (i >= 0) {
                c.h[i] = new Dot(false);
                gl.setConstraints(c.h[i], normal);
                c.add(c.h[i]);
                Spacer space = new Spacer(sSize);
                gl.setConstraints(space, cSpace);
                c.add(space);
                c.min[i] = new Dot(false);
                gl.setConstraints(c.min[i], normal);
                c.add(c.min[i]);
                space = new Spacer(sSize);
                gl.setConstraints(space, cSpace);
                c.add(space);
                c.sec[i] = new Dot(false);
                gl.setConstraints(c.sec[i], right);
                c.add(c.sec[i]);
                --i;
            }
            c.drawTime();
            c.t.start();
            return c;
        }

        public void drawTime() {
            Calendar c = Calendar.getInstance();
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(2);
            if (this.real_binnary) {
                boolean tmp;
                String hT = "";
                int hour = c.get(11);
                int i = 0;
                while (i < this.h.length) {
                    tmp = (hour & 1 << i) > 0;
                    hT = tmp ? "1" + hT : "0" + hT;
                    this.h[i].setShining(tmp);
                    ++i;
                }
                this.hL.setText(hT, nf.format(hour));
                String minT = "";
                int minute = c.get(12);
                int i2 = 0;
                while (i2 < this.min.length) {
                    tmp = (minute & 1 << i2) > 0;
                    minT = tmp ? "1" + minT : "0" + minT;
                    this.min[i2].setShining(tmp);
                    ++i2;
                }
                this.minL.setText(minT, nf.format(minute));
                String secT = "";
                int second = c.get(13);
                int i3 = 0;
                while (i3 < this.sec.length) {
                    tmp = (second & 1 << i3) > 0;
                    secT = tmp ? "1" + secT : "0" + secT;
                    this.sec[i3].setShining(tmp);
                    ++i3;
                }
                this.secL.setText(secT, nf.format(second));
            } else {
                boolean tmp;
                String ehT = "";
                String zhT = "";
                int hour = c.get(11);
                int houre = hour % 10;
                int hourz = hour / 10;
                int i = 0;
                while (i < this.h.length / 2) {
                    tmp = (houre & 1 << i) > 0;
                    ehT = tmp ? "1" + ehT : "0" + ehT;
                    this.h[i].setShining(tmp);
                    tmp = (hourz & 1 << i) > 0;
                    zhT = tmp ? "1" + zhT : "0" + zhT;
                    this.h[i + this.h.length / 2].setShining(tmp);
                    ++i;
                }
                this.hL.setText(zhT, nf.format(hour), ehT);
                String emT = "";
                String zmT = "";
                int minute = c.get(12);
                int minutee = minute % 10;
                int minutez = minute / 10;
                int i4 = 0;
                while (i4 < this.min.length / 2) {
                    tmp = (minutee & 1 << i4) > 0;
                    emT = tmp ? "1" + emT : "0" + emT;
                    this.min[i4].setShining(tmp);
                    tmp = (minutez & 1 << i4) > 0;
                    zmT = tmp ? "1" + zmT : "0" + zmT;
                    this.min[i4 + this.min.length / 2].setShining(tmp);
                    ++i4;
                }
                this.minL.setText(zmT, nf.format(minute), emT);
                String esT = "";
                String zsT = "";
                int second = c.get(13);
                int seconde = second % 10;
                int secondz = second / 10;
                int i5 = 0;
                while (i5 < this.sec.length / 2) {
                    tmp = (seconde & 1 << i5) > 0;
                    esT = tmp ? "1" + esT : "0" + esT;
                    this.sec[i5].setShining(tmp);
                    tmp = (secondz & 1 << i5) > 0;
                    zsT = tmp ? "1" + zsT : "0" + zsT;
                    this.sec[i5 + this.sec.length / 2].setShining(tmp);
                    ++i5;
                }
                this.secL.setText(zsT, nf.format(second), esT);
            }
        }

        public void run() {
            try {
                do {
                    this.drawTime();
                    Thread.sleep(1000L);
                } while (!Thread.interrupted() && this.t != null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void halt() {
            if (this.t != null && this.t.isAlive()) {
                this.t.interrupt();
                try {
                    this.t.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.t = null;
        }

        private static class TimeLabel
        extends Panel {
            Label eins = new Label("-");
            Label zwei = new Label("-");
            Label drei = new Label("-");
            boolean three_out = false;

            public TimeLabel() {
                this(false);
            }

            public TimeLabel(boolean three_fields) {
                this.three_out = three_fields;
                GridBagLayout gl = new GridBagLayout();
                this.setLayout(gl);
                GridBagConstraints normal = new GridBagConstraints();
                normal.anchor = 10;
                normal.fill = 2;
                normal.weightx = 1.0;
                normal.weighty = 0.0;
                GridBagConstraints right = new GridBagConstraints();
                right.anchor = 10;
                right.fill = 2;
                right.weightx = 1.0;
                right.weighty = 0.0;
                right.gridwidth = 0;
                Font f = new Font("Monospaced", 1, 12);
                if (three_fields) {
                    this.eins.setText("0000");
                    this.eins.setBackground(bg);
                    this.eins.setForeground(bin_time);
                    this.eins.setAlignment(1);
                    this.eins.setFont(f);
                    gl.setConstraints(this.eins, normal);
                    this.add(this.eins);
                    Label spacer = new Label("-");
                    spacer.setBackground(bg);
                    spacer.setForeground(bin_time);
                    spacer.setAlignment(1);
                    spacer.setFont(f);
                    gl.setConstraints(spacer, normal);
                    this.add(spacer);
                    this.zwei.setText("00");
                    this.zwei.setBackground(bg);
                    this.zwei.setForeground(time);
                    this.zwei.setAlignment(1);
                    this.zwei.setFont(f);
                    gl.setConstraints(this.zwei, normal);
                    this.add(this.zwei);
                    spacer = new Label("-");
                    spacer.setBackground(bg);
                    spacer.setForeground(bin_time);
                    spacer.setAlignment(1);
                    spacer.setFont(f);
                    gl.setConstraints(spacer, normal);
                    this.add(spacer);
                    this.drei.setText("0000");
                    this.drei.setBackground(bg);
                    this.drei.setForeground(bin_time);
                    this.drei.setAlignment(1);
                    this.drei.setFont(f);
                    gl.setConstraints(this.drei, right);
                    this.add(this.drei);
                } else {
                    this.eins.setText("00000000");
                    this.eins.setBackground(bg);
                    this.eins.setForeground(bin_time);
                    this.eins.setAlignment(1);
                    this.eins.setFont(f);
                    gl.setConstraints(this.eins, normal);
                    this.add(this.eins);
                    Label spacer = new Label("-");
                    spacer.setBackground(bg);
                    spacer.setForeground(bin_time);
                    spacer.setAlignment(1);
                    spacer.setFont(f);
                    gl.setConstraints(spacer, normal);
                    this.add(spacer);
                    this.drei.setText("00");
                    this.drei.setBackground(bg);
                    this.drei.setForeground(time);
                    this.drei.setAlignment(1);
                    this.drei.setFont(f);
                    gl.setConstraints(this.drei, right);
                    this.add(this.drei);
                }
            }

            public void setText(String left, String right) {
                if (this.three_out) {
                    throw new IllegalArgumentException("call setText(String, String, String) if constructing with three fields");
                }
                this.eins.setText(left);
                this.drei.setText(right);
            }

            public void setText(String left, String mid, String right) {
                if (!this.three_out) {
                    throw new IllegalArgumentException("call setText(String, String) if constructing with two fields");
                }
                this.eins.setText(left);
                this.zwei.setText(mid);
                this.drei.setText(right);
            }

            public Dimension getMinimumSize() {
                Dimension r = this.zwei.getMinimumSize();
                Dimension m = this.drei.getMinimumSize();
                Dimension l = this.eins.getMinimumSize();
                return new Dimension(r.width + m.width + l.width, Math.max(r.height, Math.max(m.height, l.height)));
            }

            public Dimension getPreferredSize() {
                Dimension r = this.zwei.getPreferredSize();
                Dimension m = this.drei.getPreferredSize();
                Dimension l = this.eins.getPreferredSize();
                return new Dimension(r.width + m.width + l.width, Math.max(r.height, Math.max(m.height, l.height)));
            }
        }

        private static class Dot
        extends Canvas {
            boolean shining;

            public Dot() {
                this(false);
            }

            public Dot(boolean shining) {
                this.shining = shining;
                this.setBackground(bg);
                this.setForeground(on);
            }

            public void paint(Graphics g) {
                g.setColor(bg);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.shining) {
                    g.setColor(on);
                } else {
                    g.setColor(off);
                }
                g.fillOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }

            public Dimension getMinimumSize() {
                return new Dimension(5, 5);
            }

            public Dimension getPreferredSize() {
                return new Dimension(55, 55);
            }

            public void setShining(boolean b) {
                if (this.shining != b) {
                    this.shining = b;
                    this.repaint();
                }
            }

            public boolean getShining() {
                return this.shining;
            }
        }
    }

    public static class ClockFrame
    extends Frame
    implements WindowListener {
        Clock c = null;

        public ClockFrame() throws HeadlessException {
            this(1);
        }

        private static String getTitle(int type) {
            String ending = " BinnaryClock";
            switch (type) {
                case 1: {
                    return "Grouped" + ending;
                }
                case 2: {
                    return "packed Grouped" + ending;
                }
                case 3: {
                    return "easy Grouped" + ending;
                }
                case 0: {
                    return "Plain" + ending;
                }
            }
            throw new IllegalArgumentException(String.valueOf(type) + " als Typ unbekannt");
        }

        public static void raiseClockFrame(String what) {
            if (what == null || what.equals("grouped")) {
                new ClockFrame(1).show();
            } else if (what.equals("packedGrouped")) {
                new ClockFrame(2).show();
            } else if (what.equals("plain")) {
                new ClockFrame(0).show();
            } else if (what.equals("easyGrouped")) {
                new ClockFrame(3).show();
            } else {
                throw new IllegalArgumentException(String.valueOf(what) + " kann nicht als Parameter interpretiert werden.\n" + "M\u00f6glich sind: plain, grouped, packedGrouped und easyGrouped");
            }
        }

        public ClockFrame(int type) throws HeadlessException {
            super(ClockFrame.getTitle(type));
            this.addWindowListener(this);
            switch (type) {
                default: {
                    this.c = Clock.getGroupedClock(Clock.BIG);
                    this.add(this.c);
                    break;
                }
                case 2: {
                    this.c = Clock.getGroupedClock(Clock.PACKED);
                    this.add(this.c);
                    break;
                }
                case 3: {
                    this.c = Clock.getGroupedClock(Clock.EASY);
                    this.add(this.c);
                    break;
                }
                case 0: {
                    this.c = Clock.getClock();
                    this.add(this.c);
                }
            }
            this.pack();
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            this.dispose();
        }

        public void windowClosed(WindowEvent e) {
            if (this.c != null) {
                this.c.halt();
            }
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }

    private static class Ask
    extends Dialog
    implements ActionListener,
    WindowListener {
        Checkbox plain = new Checkbox("Plain");
        Checkbox grouped = new Checkbox("Grouped");
        Checkbox packedGrouped = new Checkbox("packed Grouped");
        Checkbox easyGrouped = new Checkbox("easy Grouped");
        Button ok = new Button("OK");
        Button cancel = new Button("Abbrechen");
        static String title = "Welche Bin\u00e4re Uhr wollen sie?";

        public static void ask() {
            Frame j = new Frame(title);
            j.show();
            Ask a = new Ask(j);
            a.show();
            j.dispose();
        }

        public Ask(Frame f) {
            super(f, title, true);
            GridBagLayout gl = new GridBagLayout();
            this.setLayout(gl);
            this.addWindowListener(this);
            GridBagConstraints normal = new GridBagConstraints();
            normal.anchor = 10;
            normal.fill = 1;
            normal.weightx = 1.0;
            normal.weighty = 1.0;
            normal.gridwidth = 0;
            gl.setConstraints(this.plain, normal);
            this.add(this.plain);
            gl.setConstraints(this.grouped, normal);
            this.add(this.grouped);
            gl.setConstraints(this.packedGrouped, normal);
            this.add(this.packedGrouped);
            gl.setConstraints(this.easyGrouped, normal);
            this.add(this.easyGrouped);
            normal.gridwidth = 1;
            this.ok.setActionCommand("ok");
            this.ok.addActionListener(this);
            gl.setConstraints(this.ok, normal);
            this.add(this.ok);
            normal.gridwidth = 0;
            this.cancel.setActionCommand("cancel");
            this.cancel.addActionListener(this);
            gl.setConstraints(this.cancel, normal);
            this.add(this.cancel);
            this.pack();
        }

        public void raiseWindows() {
            ClockFrame cf;
            if (this.plain.getState()) {
                cf = new ClockFrame(0);
                cf.show();
            }
            if (this.grouped.getState()) {
                cf = new ClockFrame(1);
                cf.show();
            }
            if (this.packedGrouped.getState()) {
                cf = new ClockFrame(2);
                cf.show();
            }
            if (this.easyGrouped.getState()) {
                cf = new ClockFrame(3);
                cf.show();
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("ok")) {
                this.raiseWindows();
                this.dispose();
            } else if (e.getActionCommand().equals("cancel")) {
                this.dispose();
            }
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            this.dispose();
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

