import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * Created on 27.10.2003
 */

/**
 * @author TheConstructor
 * @version 0.1
 * @since 27.10.2003 14:53:02
 */
public class WorldTime extends Applet implements Runnable, ActionListener
{
	String timeFormat = "d MMM yyyy HH:mm:ss z ('GMT' Z)";
	
	CheckboxGroup radios = new CheckboxGroup();

	TextField localTime;
	Checkbox dspLocalTime;
	TextField gmt;
	Checkbox dspGmt;
	TextField remoteTime;
	Checkbox dspRemoteTime;
	TextField starDate;
	Checkbox dspStarDate;
	TextField internetTime;
	Checkbox dspInternetTime;
	
	Checkbox dspNone;

	Button startStop;

	boolean running = false;

	Choice zoneSelector;

	Date time;

	Thread t = new Thread(this);

	/**
	 * @throws java.awt.HeadlessException
	 */
	public WorldTime() throws HeadlessException
	{
		super();
		GridBagLayout gl = new GridBagLayout();

		this.setLayout(gl);
		this.setBackground(SystemColor.control);

		GridBagConstraints gc = new GridBagConstraints();
		GridBagConstraints lc = new GridBagConstraints();
		GridBagConstraints rc = new GridBagConstraints();

		Label label;

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.weightx = 1.0;
		gc.weighty = 0.0;
		gc.insets = new Insets(5, 5, 0, 5);
		gc.gridwidth = 1;
		gc.ipadx = 2;
		gc.ipady = 2;

		rc.fill = GridBagConstraints.NONE;
		rc.weightx = 0.0;
		rc.weighty = 0.0;
		rc.insets = new Insets(5, 5, 0, 5);
		rc.gridwidth = GridBagConstraints.REMAINDER;
		rc.anchor = GridBagConstraints.NORTH;

		lc.fill = GridBagConstraints.NONE;
		lc.weightx = 0.0;
		lc.weighty = 0.0;
		lc.insets = new Insets(5, 5, 0, 5);
		lc.gridwidth = 1;
		lc.anchor = GridBagConstraints.NORTH;

		label = new Label("Local", Label.RIGHT);
		gl.setConstraints(label, lc);
		this.add(label);

		localTime = new TextField();
		localTime.setEditable(false);
		this.add(localTime);
		gl.setConstraints(localTime, gc);
		
		dspLocalTime = new Checkbox("", radios, false);
		this.add(dspLocalTime);
		gl.setConstraints(dspLocalTime, rc);
		

		label = new Label("UTC", Label.RIGHT);
		gl.setConstraints(label, lc);
		this.add(label);

		gmt = new TextField();
		gmt.setEditable(false);
		this.add(gmt);
		gl.setConstraints(gmt, gc);
		
		dspGmt = new Checkbox("", radios, false);
		this.add(dspGmt);
		gl.setConstraints(dspGmt, rc);

		lc.gridheight = 2;

		label = new Label("Remote", Label.RIGHT);
		gl.setConstraints(label, lc);
		this.add(label);

		lc.gridheight = 1;

		remoteTime = new TextField();
		remoteTime.setEditable(false);
		this.add(remoteTime);
		gl.setConstraints(remoteTime, gc);
		
		dspRemoteTime = new Checkbox("", radios, false);
		this.add(dspRemoteTime);
		gl.setConstraints(dspRemoteTime, rc);

		String[] stemp = TimeZone.getAvailableIDs();
		String[] ltemp = new String[stemp.length + 48];
		System.arraycopy(stemp, 0, ltemp, 48, stemp.length);

		NumberFormat n = NumberFormat.getIntegerInstance();
		n.setMinimumIntegerDigits(2);
		n.setMaximumIntegerDigits(2);
		for (int i = 1; i <= 12; i++)
		{
			ltemp[i - 1] = "GMT+" + n.format(i) + "00";
			ltemp[i + 11] = "GMT-" + n.format(i) + "00";
		}
		for (int i = 0; i < 12; i++)
		{
			ltemp[i + 24] = "GMT+" + n.format(i) + "30";
			ltemp[i + 36] = "GMT-" + n.format(i) + "30";
		}

		Arrays.sort(ltemp, String.CASE_INSENSITIVE_ORDER);
		
		gc.gridwidth = GridBagConstraints.REMAINDER;

		zoneSelector = new Choice();
		for(int i = 0; i < ltemp.length; i++)
		{
			zoneSelector.add(ltemp[i]);
		}
		this.add(zoneSelector);
		gl.setConstraints(zoneSelector, gc);
		
		gc.gridwidth = 1;

		label = new Label("StarDate", Label.RIGHT);
		gl.setConstraints(label, lc);
		this.add(label);

		starDate = new TextField();
		starDate.setEditable(false);
		this.add(starDate);
		gl.setConstraints(starDate, gc);
		
		dspStarDate = new Checkbox("", radios, false);
		this.add(dspStarDate);
		gl.setConstraints(dspStarDate, rc);

		label = new Label("InetTime", Label.RIGHT);
		gl.setConstraints(label, lc);
		this.add(label);

		internetTime = new TextField();
		internetTime.setEditable(false);
		this.add(internetTime);
		gl.setConstraints(internetTime, gc);
		
		dspInternetTime = new Checkbox("", radios, false);
		this.add(dspInternetTime);
		gl.setConstraints(dspInternetTime, rc);
		
		gc.gridwidth = 2;

		startStop = new Button("Stop!");
		startStop.setActionCommand("startStop");
		startStop.addActionListener(this);
		this.add(startStop);
		gl.setConstraints(startStop, gc);
		
		dspNone = new Checkbox("", radios, true);
		this.add(dspNone);
		gl.setConstraints(dspNone, rc);

		t.start();

	}

	public void init()
	{
		this.setSize(245, 200);
	}
	
	private boolean showedTitle = false;
	public void showTime(String time)
	{
		String titel;
		if(time == null)
		{
			if(showedTitle)
			{
				return;
			}else
			{
				showedTitle = true;
			}
			titel = "Matthias's Universal Clock";
		}else
		{
			titel = time;// + " (M's UClock)";
			showedTitle = false;
		}
		if(parent != null)
		{
			parent.setTitle(titel);
		}else
		{
			showStatus(titel);
		}
	}

	/**
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run()
	{
		try
		{
			running = true;
			while (running && this != null && t != null)
			{
				time = new Date();
				DateFormat formatter = new SimpleDateFormat(timeFormat);

				localTime.setText(formatter.format(time));
				if(dspLocalTime.getState())
				{
					showTime(formatter.format(time));
				}

				formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
				gmt.setText(formatter.format(time));
				if(dspGmt.getState())
				{
					showTime(formatter.format(time));
				}

				formatter.setTimeZone(
					TimeZone.getTimeZone(
						(String) zoneSelector.getSelectedItem()));
				remoteTime.setText(formatter.format(time));
				if(dspRemoteTime.getState())
				{
					showTime(formatter.format(time));
				}

				Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

				long elapsed =
					c.get(Calendar.SECOND)
						+ 60 * c.get(Calendar.MINUTE)
						+ 3600 * c.get(Calendar.HOUR_OF_DAY)
						+ 86400 * (c.get(Calendar.DAY_OF_YEAR) - 1);
				int nowYear = c.get(Calendar.YEAR);
				long thisyear = Math.round(elapsed / 315.36) / 100;
				long issue = Math.round(((nowYear - 2323) / 100) - .5);
				long yearspast = (nowYear - (2323 + (issue * 100))) * 1000;
				long total = thisyear + yearspast;

				NumberFormat intF = NumberFormat.getIntegerInstance();
				intF.setMinimumIntegerDigits(2);
				String temp2 =
					"["
						+ issue
						+ "]  "
						+ total
						+ "  "
						+ c.get(Calendar.HOUR_OF_DAY)
						+ ":"
						+ intF.format(c.get(Calendar.MINUTE))
						+ ":"
						+ intF.format(c.get(Calendar.SECOND));
				starDate.setText(temp2);
				if(dspStarDate.getState())
				{
					showTime(temp2);
				}

				c = Calendar.getInstance(TimeZone.getTimeZone("GMT+1"));

				NumberFormat doubleF = NumberFormat.getInstance();
				doubleF.setMinimumFractionDigits(2);
				doubleF.setMaximumFractionDigits(2);

				temp2 =
					intF.format(c.get(Calendar.DAY_OF_MONTH))
						+ "."
						+ intF.format(c.get(Calendar.MONTH) + 1)
						+ "."
						+ c.get(Calendar.YEAR)
						+ " @ "
						+ doubleF.format(
							Math.round(
								((c.get(Calendar.HOUR_OF_DAY)) * 3600.0
									+ ((c.get(Calendar.MINUTE)) * 60.0)
									+ c.get(Calendar.SECOND))
									/ 0.864)
								/ 100.0);
				internetTime.setText(temp2);
				if(dspInternetTime.getState())
				{
					showTime(temp2);
				}
				
				if(dspNone.getState())
				{
					showTime(null);
				}
				

				if (parent != null)
				{
					parent.pack();
				}else
				{
					this.getParent().validate();
				}

				Thread.sleep(1000);
			}
		} catch (InterruptedException e)
		{
		}
	}

	/**
	 * 
	 * 
	 * @see java.applet.Applet#stop()
	 */
	public void stop()
	{
		running = false;
		if (t.isAlive())
		{
			t.interrupt();
		}
	}

	/**
	 * @param e
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		if (e.getActionCommand() == "startStop")
		{
			running = !running;
			if (running)
			{
				t = new Thread(this);
				t.start();
				startStop.setLabel("Stop!");
			} else
			{
				startStop.setLabel("ReStart!");
			}
		}else
		{
			System.out.println(e.getActionCommand() + "?");
		}
		if (parent != null)
		{
			parent.pack();
		}
	}

	public static void main(String[] argc)
	{
		AppletHolder ah = new AppletHolder();
		ah.show();
	}

	AppletHolder parent = null;

	/**
	 * @param holder
	 */
	public void setParent(AppletHolder holder)
	{
		parent = holder;
	}
}

class AppletHolder extends Frame implements WindowListener
{
	WorldTime wt = new WorldTime();

	public AppletHolder()
	{
		super("Matthias's Universal Clock");
		this.add(wt);
		wt.init();
		wt.setParent(this);
		this.addWindowListener(this);
		this.pack();
		this.setResizable(false);
		this.setBackground(SystemColor.control);
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowOpened(java.awt.event.WindowEvent)
	 */
	public void windowOpened(WindowEvent e)
	{
		wt.start();
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
	 */
	public void windowClosing(WindowEvent e)
	{
		this.dispose();
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowClosed(java.awt.event.WindowEvent)
	 */
	public void windowClosed(WindowEvent e)
	{
		wt.stop();
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowIconified(java.awt.event.WindowEvent)
	 */
	public void windowIconified(WindowEvent e)
	{
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowDeiconified(java.awt.event.WindowEvent)
	 */
	public void windowDeiconified(WindowEvent e)
	{
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowActivated(java.awt.event.WindowEvent)
	 */
	public void windowActivated(WindowEvent e)
	{
	}

	/**
	 * @param e
	 * @see java.awt.event.WindowListener#windowDeactivated(java.awt.event.WindowEvent)
	 */
	public void windowDeactivated(WindowEvent e)
	{
	}
}